% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_corr.r
\name{age_corr}
\alias{age_corr}
\title{Function that corrects chronologies for sudden jumps in time}
\usage{
age_corr(resultarray, T_per, plot, agecorrection)
}
\arguments{
\item{resultarray}{Array containing the full results of
the optimized growth model}

\item{T_per}{The period length of one year (in days)}

\item{plot}{Should the results be plotted? (/code{TRUE/FALSE})}

\item{agecorrection}{Correct for jumps in age (/code{TRUE}) or
only for starting time (/code{FALSE})}
}
\value{
An updated and corrected version of \code{resultarray}
}
\description{
Some occurrences in the model results can lead the CumDY function
to detect extra year transitions, resulting in sudden jumps in
the shell chronology or a start of the chronology at an age
beyond 1 year. This function removes these sharp transitions
and late onset by adding or subtracting whole years to the age
result.
}
\examples{
testarray <- array(NA, dim = c(20, 16, 9)) # Create empty array
# with correct third dimension
windowfill <- seq(10, 100, 10) # Create dummy simulation data 
# (ages) to copy through the array
for(i in 6:length(testarray[1, , 1])){
    testarray[, i, 3] <- c(windowfill,
        rep(NA, length(testarray[, 1, 3]) - length(windowfill)))
    windowfill <- c(NA, windowfill + 31)
}
testarray2 <- age_corr(testarray, 365, FALSE, FALSE) # Apply function on 
array
}
\references{
package dependencies: ggplot2 3.2.1
}
