% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapeRotator.R
\name{join.arrays}
\alias{join.arrays}
\title{join.arrays}
\usage{
join.arrays(data.1, data.2)
}
\arguments{
\item{data.1}{an object of the class "array" that contains the rotated
three-dimensional landmarks for structure #1 (e.g. skull)}

\item{data.2}{an object of the class "array" that contains the rotated
three-dimensional landmarks for structure #2 (e.g. mandible)}
}
\value{
This function returns an array of the joined two arrays comprising the
  two rotated structures (e.g. mandible and skull).
}
\description{
Joins the two rotated arrays and returns a single array
}
\details{
This function join the two arrays that were rotated using
double.rotation() or simple.rotation() and return a big array from joining
the two smaller arrays. It is possible to translate one of the objects after
the rotation, in the case of not wanting them in contact to one another, or
in a slightly different location. The vector used in the translation might
have to change depending on the angle used in the rotation function, in
order to represent biologically-relevant positions of the two structures
relative to one another.
}
\examples{
\donttest{
rotation_45 = double.rotation(data.1, data.2, land.a, land.b, land.c, land.d,
land.e, land.f, land.g, land.h, 45)

rotation_45_t <- join.arrays(rotation_45$rotated1, rotation_45$rotated2)

# The datasets can also be joined after further translation
rotation_45_t <- join.arrays(rotation_45$rotated1,
translate(rotation_45$rotated2, land.e , skull_translate))
}

}
\references{
M. Vidal-García, L. Bandara and J.S. Keogh. 2018. ShapeRotator:
An R tool for standardized rigid rotations of articulated three-dimensional
structures with application for geometric morphometrics.
Ecology and Evolution. DOI: 10.1002/ece3.4018
}
\author{
Marta Vidal-Garcia
}
