% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/utils.R
\name{CheckMatrix}
\alias{CheckMatrix}
\alias{CheckMatrix.default}
\alias{CheckMatrix.dMatrix}
\alias{CheckMatrix.lMatrix}
\title{Check Matrix Validity}
\usage{
CheckMatrix(object, checks, ...)

\method{CheckMatrix}{default}(object, checks, ...)

\method{CheckMatrix}{dMatrix}(object, checks = c("infinite", "logical", "integer", "na"), ...)

\method{CheckMatrix}{lMatrix}(object, checks = c("infinite", "logical", "integer", "na"), ...)
}
\arguments{
\item{object}{A matrix}

\item{checks}{Type of checks to perform, choose one or more from:
\itemize{
 \item \dQuote{\code{infinite}}: Emit a warning if any value is infinite
 \item \dQuote{\code{logical}}: Emit a warning if any value is a logical
 \item \dQuote{\code{integer}}: Emit a warning if any value is \emph{not}
  an integer
 \item \dQuote{\code{na}}: Emit a warning if any value is an \code{NA}
  or \code{NaN}
}}

\item{...}{Arguments passed to other methods}
}
\value{
Emits warnings for each test and invisibly returns \code{NULL}
}
\description{
Check Matrix Validity
}
\keyword{internal}
