% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcori_conditional_means.R
\name{pcori_conditional_means}
\alias{pcori_conditional_means}
\title{Compute Conditional Means}
\usage{
pcori_conditional_means(model, alpha = 0, new.data = model.frame(model), ...)
}
\arguments{
\item{model}{An object of class \code{SensIAT::outcome-model}}

\item{alpha}{Sensitivity parameter}

\item{new.data}{Data to compute conditional means for, defaults to the model frame for the fitted model.}

\item{...}{passed onto methods.}
}
\value{
The \code{new.data} frame with additional columns \code{E_Y_past}, and \code{E_exp_alphaY} appended.
}
\description{
Compute Conditional Means
}
\details{
Compute the conditional expectations needed for predictions in the models.
Three additional values/expectations are computed:
\itemize{
\item \verb{$E \\big[ Y(t) \\exp \\\{  \\alpha Y(t) \\\}   | A(t)=1, \\bar\{O\}(t) \\big]$}, returned as \code{E_y_past}, and
\item \verb{$E \\big[ \\exp \\\{ \\alpha Y(t) \\\} \\  | A(t)=1, \\bar\{O\}(t) \\big]$}, returned as \code{E_exp_alphaY}.
}
}
