% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/destr.R
\name{destr}
\alias{destr}
\title{De-string Responses}
\usage{
destr(rmat, column, sep)
}
\arguments{
\item{rmat}{A \link[SemNetCleaner]{textcleaner} filtered response matrix}

\item{column}{The column number or name of the stringed response}

\item{sep}{Separating string character (e.g., " ", ".", ",").
Must be input as a character}
}
\value{
A list containing four objects:

\item{rmat}{A response matrix that has been de-stringed}

\item{part}{The row number is supplied for each case that was affected.
This can be used to replicate the de-stringing process and to keep track of changes more generally}

\item{added}{Stringed responses that were added to the response matrix}

\item{removed}{Stringed responses that were removed from the response matrix}
}
\description{
De-string responses after performing \link[SemNetCleaner]{textcleaner}
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1:3)]

# Clean and prepocess data
clean <- textcleaner(raw, partBY = "row", dictionary = "animals")

# Obtain binary data
bin <- clean$binary

# Change column name as an example
colnames(bin)[1] <- "alpaca.ant.antelope"

# De-string
if(interactive())
{convmat <- destr(bin, "alpaca.ant.antelope", ".")}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
