#Openness and Verbal Fluency----
#' Openness and Verbal Fluency
#'
#' Raw Animals verbal fluency data (\emph{n} = 516) from Christensen et al. (2018).
#' 
#' First column is a grouping variable (\code{"Group"}) with \code{1} corresponding
#' to low openness to experience and \code{2} to high openness to experience
#' 
#' Second column is the latent variable of openness to experience with Intellect items removed
#' (see Christensen et al., 2018 for more details).
#' 
#' Third column is the ID variable for each participant.
#' 
#' Columns 4-38 are raw fluency data.
#' 
#' @name open.animals
#' 
#' @docType data
#' 
#' @usage data(open.animals)
#' 
#' @format open.animals (matrix 516 x 38)
#' 
#' @keywords datasets
#' 
#' @references
#' Christensen, A. P., Kenett, Y. N., Cotter, K. N., Beaty, R. E., & Silvia, P. J. (2018).
#' Remotely close associations: Openness to experience and semantic memory structure.
#' \emph{European Journal of Personality}, \emph{32}, 480-492.
#' doi:\href{https://doi.org/10.1002/per.2157}{10.1002/per.2157}
#' 
#' @examples 
#' data("open.animals")
NULL
#----