% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitstr.check.R
\name{splitstr.check}
\alias{splitstr.check}
\title{Split String Check}
\usage{
splitstr.check(string, split = " ", dictionary, remember = list())
}
\arguments{
\item{string}{Character.
A string of words (see examples)}

\item{split}{Character.
A character that should be used to "split"
the words input into the \code{string} argument.
Defaults to a space (\code{" "})}

\item{dictionary}{Dictionary to check.
See \code{\link{SemNetDictionaries}}}

\item{remember}{Character list.
Checks if split string has already been
checked (a wrapper argument for \code{\link[SemNetCleaner]{spell.check.dictionary}}).
Defaults to an empty list}
}
\value{
Returns the string as is or with the selected responses merged
}
\description{
A wrapper function for spell-checking
(ensures next word does not belong to the previous)
}
\examples{
#create long word vector
words <- "bombay opossum guinea pig horse cow"

\dontrun{

splitstr.check(string = words, split = " ", dictionary = SemNetDictionaries::animals.dictionary)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
