% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemanticNetworkCleaner.R
\name{partboot}
\alias{partboot}
\title{Partial Bootstrapped Semantic Network Analysis}
\usage{
partboot(data, paired = NULL, n, iter = 1000, corr = c("cor", "cosine"),
  cores, seeds = NULL)
}
\arguments{
\item{data}{Cleaned response matrix}

\item{paired}{Should bootstrapped nodes be paired?
Defaults to NULL.
Input a matrix, data frame or list containing another sample}

\item{n}{Number of nodes for bootstrap.
Defaults to round(ncol(data)/2,0) (i.g., 50\% of nodes)}

\item{iter}{Number of iterations in bootstrap.
Defaults to 1000}

\item{corr}{Association method to use.
Defaults to "cosine"}

\item{cores}{Number of computer processing cores to use for bootstrapping samples.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maxmimum amount of cores on your computer}

\item{seeds}{Seeds used in previous run.
Defaults to NULL.
Input a vector from previous run to replicate analyses}
}
\value{
Returns a list that includes the original semantic network measures (origmeas; ASPL, CC, Q, S),
the bootstrapped semantic network measures (bootmeas),
and Seeds that can be used to replicate analysis
}
\description{
Bootstraps (without replacement) the nodes in the network and computes global network characteristics
}
\examples{
#finalize rmatA
finalCmat <- finalize(convmat)
#finalize rmatB
finalRmat <- finalize(rmat)

#equate rmatA and rmatB
eq1 <- equate(finalCmat,finalRmat)

#obtain respective equated response matrices
eqCmat <- eq1$rmatA
eqRmat <- eq1$rmatB

\donttest{
results <- partboot(eqCmat, eqRmat, iter = 10, corr = "cosine", cores = 4)
}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
