% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partboot.R
\name{partboot}
\alias{partboot}
\title{Partial Bootstrapped Semantic Network Analysis}
\usage{
partboot(data, paired = NULL, percent, sim, weighted = FALSE,
  iter = 1000, cores)
}
\arguments{
\item{data}{Matrix or data frame.
Cleaned response matrix}

\item{paired}{Matrix or data frame.
Input for a second network to be paired with \code{data}.
Defaults to \code{NULL}.
Input a matrix or data frame containing another sample}

\item{percent}{Numeric.
Percent of nodes to remain in the network.
Defaults to \code{.50}}

\item{sim}{Character.
Similarity measure to use.
Defaults to \code{"cosine"}.
See \code{\link[SemNeT]{similarity}} for other options}

\item{weighted}{Boolean.
Should weighted ASPL and CC be used?
Defaults to \code{FALSE}.
Set to \code{TRUE} for weighted ASPL and CC}

\item{iter}{Numeric.
Number of iterations in bootstrap.
Defaults to \code{1000}}

\item{cores}{Numeric.
Number of computer processing cores to use for bootstrapping samples.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maxmimum amount of cores on your computer
(see \code{parellel::detectCores()})}
}
\value{
Returns a list containing:

\item{dataMeas}{A matrix for the network input in the \code{data}
arugment, where columns are the semantic network measures
from \code{\link[SemNeT]{semnetmeas}} and rows are their values from each
bootstrapped sample (results in a matrix with the dimensions \code{iter} by 3)}

\item{dataSumm}{Summary statistics across the bootrapped samples for the
network input in the \code{data} argument}

\item{percent}{Outputs the percent used from the \code{percent} argument}

\item{iter}{Outputs the number of bootstrapped samples
used from the \code{iter} argument}

If a \code{paired} network is input, then also returns:

\item{pairedMeas}{A matrix for the network input in the \code{paired}
arugment, where columns are the semantic network measures
from \code{\link[SemNeT]{semnetmeas}} and rows are their values from each
bootstrapped sample (results in a matrix with the dimensions \code{iter} by 3)}

\item{pairedSumm}{Summary statistics across the bootrapped samples for the
network input in the \code{paired} argument}
}
\description{
Bootstraps (without replacement) the nodes in the network and computes global network characteristics
}
\examples{
# Simulate Dataset
one <- sim.fluency(20)
\donttest{
# Run partial bootstrap networks
one.result <- partboot(data = one, percent = .50, iter = 1000,
sim = "cosine", cores = 2)
}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
