\name{SeerRegs_CM_Data}
\alias{SeerRegs_CM_Data}
\docType{data}
\title{Seer Registry Cancer Mortality Rates for all sites for 2009 to 2013}
\description{
   These datasets containing the cancer mortality
   rates for 17 of the 20 U. S. Seer Registries.  The cancer mortality data was extracted from the 
   Seer*Stat website at the Seer Registry level over a 5 year period from 2009 to 2013 
   for all cancer sites on September 30, 2016.
   }
\usage{data(SeerRegs_CM_Data)}
\format{ 
  All rates are 5 year age adjusted rates for the period 2009 to 2013.
  The dataset contains 10 columns: 
  \describe{
   \item{Registry}{is a character string name for the Seer Registry.
    }
   \item{saID}{is a character string abbreviation for the Seer Registry. See below for a list of 
     supported abbreviations.
    }
   \item{All_Both}{is a numeric value for the age adjusted rate for all races for both sexes.
    }
   \item{All_Males}{is a numeric value for the age adjusted rate for all races for males.
    }
   \item{All_Females}{is a numeric value for the age adjusted rate for all races for females.
    }
   \item{Whites_Both}{is a numeric value for the age adjusted rate for whites and both sezes.
    }
   \item{Whites_Males}{is a numeric value for the age adjusted rate for white males.
    }
   \item{Whites_Females}{is a numeric value for the age adjusted rate for white females.
    }
   \item{Blacks_Both}{is a numeric value for the age adjusted rate for blacks and both sezes.
    }
   \item{Blacks_Males}{is a numeric value for the age adjusted rate for black males.
    }
   \item{Blacks_Females}{is a numeric value for the age adjusted rate for black females.
    }
  }
  The first two rows of the data.frame represent the rate information 
  for the 17 of the 20 U. S. Seer Registries and the USA.  
  These rows MUST be deleted before using the data.frame
  with the package.
  
  The Seer Registry abbreviations, state fips ID and names used in the package are:
   \tabular{llll}{
        saID    \tab stID \tab  Alias Match\tab Name\cr
        AK-NAT\tab	02\tab	Alaska\tab      Alaska Natives\cr
        AZ-NAT\tab	04\tab	Arizona\tab     Arizona Natives\cr
        CA-OTH\tab	06\tab	Greater Calif\tab CA Other (not SF-Oakland, SJ-Monterey,  or LA)\cr
        CA-SF\tab	06\tab	San Fran\tab    California San Francisco/Oakland\cr
        CA-SJ\tab	06\tab	San Jose\tab    California San Jose/Monterey\cr
        CA-LA\tab	06\tab	Los Angeles\tab California Los Angeles Co\cr
        CT\tab 09\tab	Connecticut\tab	Connecticut\cr
        GA-OTH\tab	13\tab	Greater Geor\tab Georgia Other (not Atlanta or Rural areas)\cr
        GA-ATL\tab	13\tab	Atlanta\tab Georgia Atlanta Metro\cr
        GA-RUR\tab	13\tab	Rural Geor\tab  Rural Georgia\cr
        HI\tab	15\tab	Hawaii\tab Hawaii\cr
        IA\tab	19\tab	Iowa\tab Iowa	\cr
        KY\tab        21\tab	Kentucky\tab Kentucky\cr
        LA\tab	22\tab	Louisiana\tab Louisiana\cr
        MI-DET\tab	26\tab	Detroit\tab Michigan Detroit\cr
        NJ\tab	34\tab	Jersey\tab New Jersery\cr
        NM\tab	35\tab	New Mexico\tab New Mexico\cr
        OK-CHE\tab    40\tab Cherokee\tab	Oklahoma Cherokee Nation\cr
        UT\tab	49\tab	Utah\tab Utah\cr
        WA-SEA\tab	53\tab	Puget Sound\tab Washington Seattle-Puget Sound\cr
      }    
Data is not available for the three native american Seer Registries: 
Alaska (AK-NAT), Arizona (AZ-NAT), and a set of counties in Oklahoma (OK-CHE). These Seer Registries
are included for completeness.
The alias match strings allows the package to attempt to match location identifiers generated by 
the Seer*Stat website instead of having the caller re-label all of the records and possibly made an 
error. The recommendation is to point package at the column and see what happens.
}
\source{
 The U. S. Seer Registry age adjusted Cancer Mortality rates for the years 2009 to 2013 
 for all races, whites, and blacks for both sexes, males and females for all sites 
 was extracted from the NCI Seer*Stat website on September 30, 2016.  
 The data selected is at the Seer Registry geographic level for a 5 year period from 2009 to 2013 
 for cancer mortality for all sites to allow it to be used as example
 data in the package.
} 
\keyword{datasets}
