% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeedMatchR.R
\name{SeedMatchR}
\alias{SeedMatchR}
\title{Find seed matches in genomic features}
\usage{
SeedMatchR(
  res,
  gtf,
  seqs,
  sequence,
  seed.name = "mer7m8",
  col.name = NULL,
  mismatches = 0,
  indels = FALSE,
  tx.id.col = TRUE
)
}
\arguments{
\item{res}{A DESeq2 results \code{data.frame}}

\item{gtf}{GTF file used to map features to genes. The object must have
columns transcript_id and gene_id}

\item{seqs}{The \code{DNAStringSet} object with sequence information
for features. The names of the sequences should be the transcript names.}

\item{sequence}{The \code{DNAString} guide sequence oriented 5' > 3'.}

\item{seed.name}{The name of specific seed to extract. Options are:  mer8,
mer7A1, mer7m8, mer6}

\item{col.name}{The string to use for the column name. Defaults to seed name}

\item{mismatches}{The number of mismatches to allow in search}

\item{indels}{Whether to allow indels in search}

\item{tx.id.col}{Use the transcript_id column instead of gene_id}
}
\value{
A modified DESeq2 results dataframe that has column named after the
seed of choice representing the number of match counts.
}
\description{
Find seed matches in a \code{DNAStringSet} object of
sequences. This function will use \code{get.seed} extract the seed sequence
from the guide sequence. The seed is then searched across all rows of the
\code{DNAStringSet} object using \code{vpatterncount}.

This function returns the input DESeq2 results \code{data.frame} with an
additional column that contains the counts for the input \code{seed.name}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

seq = "UUAUAGAGCAAGAACACUGUUUU"

anno.db = load_species_anno_db("human")

features = get_feature_seqs(anno.db$tx.db, anno.db$dna)

# Load test data
res <- Schlegel_2022_Ttr_D1_30mkg

# Filter DESeq2 results for SeedMatchR
res = filter_deseq(res, fdr.cutoff=1, fc.cutoff=0, rm.na.log2fc = TRUE)

res = SeedMatchR(res, anno.db$gtf, features$seqs, seq, "mer7m8")
\dontshow{\}) # examplesIf}
}
