% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DATA.R
\docType{data}
\encoding{UTF-8}
\name{big5}
\alias{big5}
\title{Big 5 dataset}
\format{A \code{data.frame} object with \Sexpr[stage=build,results=rd]{ncol(SciencesPo::big5)} variables and \Sexpr[stage=build,results=rd]{nrow(SciencesPo::big5)} observations.}
\usage{
data(big5)
}
\description{
This is a dataset of the Big 5 personality traits. It is a measurement of the Dutch translation of the NEO-PI-R on 500 first year psychology students (Dolan, Oort, Stoel, Wicherts, 2009). The test consists of fifty items that you must rate on how true they are about you on a five point scale where 1=Disagree, 3=Neutral and 5=Agree. It takes most people 3-8 minutes to complete.

\itemize{
\item{Neuroticism}{The level of neuroticism}
\item{Extraversion}{The level of extraversion}
\item{Openness}{The level of openness}
\item{Agreeableness}{The level of agreeableness}
\item{Conscientiousness}{The level of conscientiousness}
}
}
\references{
Hoekstra, H. A., Ormel, J., & De Fruyt, F. (2003). NEO-PI-R/NEO-FFI:
Big 5 persoonlijkheidsvragenlijst. Handleiding \emph{Manual of the
Dutch version of the NEO-PI-R/NEO-FFI}. Lisse, The Netherlands:
Swets and Zeitlinger.

Dolan, C. V., Oort, F. J., Stoel, R. D., & Wicherts, J. M. (2009).
Testing measurement invariance in the target rotates multigroup
exploratory factor model. \emph{Structural Equation Modeling},
16, 295<96>314.
}
\keyword{datasets}

