% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{calc.UC}
\alias{calc.UC}
\alias{calc.UC.default}
\title{The Uncertainty Coefficient}
\usage{
calc.UC(x, y = NULL, direction = c("symmetric", "row", "column"),
  conf.level = NA, p.zero.correction = 1/sum(x)^2, ...)

\method{calc.UC}{default}(x, y = NULL, direction = c("symmetric", "row",
  "column"), conf.level = NA, p.zero.correction = 1/sum(x)^2, ...)
}
\arguments{
\item{x}{A numeric vector, a factor, matrix or data frame.}

\item{y}{A vector that is ignored if x is a matrix and required if x is a vector.}

\item{direction}{The direction of the calculation, either \code{"symmetric"} (default), \code{"row"}, or \code{"column"}. \code{"row"} calculates \code{uncertainty(R|C)} (column dependent relationship).}

\item{conf.level}{The confidence level of the interval. If set to NA (which is the default) no confidence interval will be calculated.}

\item{p.zero.correction}{Slightly nudge zero values so that their logarithm can be calculated.}

\item{\dots}{Further arguments are passed to the function \code{\link{table}}, allowing i.e. to set useNA. This refers only to the vector interface.}
}
\description{
The uncertainty coefficient \code{U(C|R)} measures the proportion of uncertainty (entropy) in the column variable \code{Y} that is explained by the row variable \code{X}.
}
\details{
The uncertainty coefficient is computed as
\deqn{U(C|R) = \frac{H(X) + H(Y) - H(XY)}{H(Y)} } and ranges from [0, 1].
}
\examples{
if (interactive()) {
# example from Goodman Kruskal (1954)
m <- as.table(cbind(c(1768,946,115), c(807,1387,438), c(189,746,288), c(47,53,16)));
dimnames(m) <- list(paste("A", 1:3), paste("B", 1:4));
print(m)

calc.UC(m); # default is direction = "symmetric"

calc.UC(m, conf.level=0.95); # direction "symmetric"

calc.UC(m, direction="column");
}
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com},
 strongly based on code from Antti Arppe \email{antti.arppe@helsinki.fi} and Andri Signorell \email{andri@signorell.net}.
}
\references{
Theil, H. (1972), \emph{Statistical Decomposition Analysis}, Amsterdam: North-Holland Publishing Company.
}
\keyword{Multivariate}

