% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Group_teachers4stud.R
\name{Group_teachers4stud}
\alias{Group_teachers4stud}
\title{Arrange the number of teachers per students in public Italian schools at the province level}
\usage{
Group_teachers4stud(
  Year = 2023,
  input_nteachers = NULL,
  nteachers_filename = c("DOCTIT", "DOCSUP"),
  verbose = TRUE,
  input_nstud_raw = NULL,
  input_nstud_aggr = NULL,
  ...
)
}
\arguments{
\item{Year}{Numeric or character value. Reference school year for the school registry data (last available is 2022).
Available in the formats: \code{2022}, \code{"2021/2022"}, \code{202122}, \code{20212022}. \code{2023} by default}

\item{input_nteachers}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}. The number of teachers by province, obtained as output of the function \code{\link{Get_nteachers_prov}}. If \code{NULL}, the function will download it automatically but it will not be saved in the global environment. \code{NULL} by default.}

\item{nteachers_filename}{Character. If \code{input_nteachers} is not provided, which data to retrieve regarding the number of teachers/personnel; see \code{\link{Get_nteachers_prov}}
\code{c("DOCTIT", "DOCSUP")} by default, i.e. tenured theachers and temporary teachers.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. TRUE by default.}

\item{input_nstud_raw}{Object of class 'list', including two objects of class \code{tbl_df}', \code{tbl} and \code{data.frame}, obtainded as output of the \code{\link{Get_nstud}} function with the default \code{filename} parameter.
Not necessary if the argument \code{input_nstud_aggr} is provided. If \code{NULL}, the function will download it automatically but it will not be saved in the global environment. \code{NULL} by default.}

\item{input_nstud_aggr}{Object of class \code{list}, including two objects of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Group_nstud}}. If \code{NULL}, the function will compute it manually but it will not be saved in the global environment. \code{NULL} by default.}

\item{...}{Arguments to \code{\link{Group_nstud}} if argument \code{input_nstud_aggr} is not provided}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}
}
\description{
This function provides the average number of teachers per students in Italian public schools at the province level.
}
\examples{


\donttest{
  input_nstud23 <- Get_nstud(2023, filename ="ALUCORSOINDCLASTA")
  Registry23 <- Get_Registry(2023)
  School2mun23 <- Get_School2mun(2023, input_Registry = Registry23)


  nstud23.aggr <- Group_nstud(Year = 2023, data = input_nstud23,
    input_Registry2 = Registry23, input_School2mun = School2mun23)

  input_nteachers23 <- Get_nteachers_prov(2023)

  Group_teachers4stud(Year = 2023, input_nteachers = input_nteachers23,
    input_nstud_aggr = nstud23.aggr)[, -c(1, 2, 10, 11)]

}

}
