% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_InnerAreas.R
\name{Get_InnerAreas}
\alias{Get_InnerAreas}
\title{Download the classification of peripheral municipalities}
\source{
<https://www.istat.it/it/archivio/273176>
}
\usage{
Get_InnerAreas()
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Retrieves the classification of Italian municipalities into six categories; classes D, E, and F are the so-called internal/inner areas; classes A, B and C are the central areas.
}
\details{
Classes are defined according to these criteria; see the methodological note (in Italian) for more detail:

\itemize{
  \item A - Standalone pole municipalities, the highest degree of centrality;
  they are characterised by a thorough and self-sufficient combined endowment of school, health and transport infrastructure,
   i.e. there are at least a lyceum and a technical high school; a railway station of medium dimensions and a hospital provided with an emergency ward.
  \item B - Intermunicipality poles; the endowment of such infrastructures is complete if a small set of contiguous municipalities is considered
}
The remaining classes are defined in terms of the national distribution of the road distances from a municipality to the closest pole:
\itemize{
  \item C - Belt municipalities, travel time below the median (< 27'42'') .
  \item D - Intermediate municipalities, travel time between the median and the third quartile (27'42'' - 40'54'').
  \item E - Peripheral municipalities, travel time between the third quartile and 97.5th percentile (40'54'' - 1h 6' 54'').
  \item F - Ultra-peripheral municipalities, travel time over the 97.5th percentile (>1h 6' 54'').
}
For more information regarding the dataset, it is possible to check the ISTAT methodological note (in Italian) available at <https://www.istat.it/it/files//2022/07/FOCUS-AREE-INTERNE-2021.pdf>
}
\examples{


InnerAreas <- Get_InnerAreas()

InnerAreas[, c(1,9,13)]

}
