% simulation.result.Rd
% From SamplerCompare, (c) 2010-2011 Madeleine Thompson

\name{simulation.result}

\alias{simulation.result}

\title{Summarize one MCMC chain}

\description{Summarize one MCMC chain in the format used by compare.samplers}

\usage{simulation.result(target.dist, sampler.name, X,
                  evals=NULL, grads=NULL, tuning=NULL, cpu=NULL,
                  burn.in=0.2, y=NULL,
                  sampler.expr=sprintf("plain('\%s')", sampler.name),
                  aborted=NA)}

\arguments{
  \item{target.dist}{A distribution object of the sort generated
    by \code{\link{make.dist}} representing the distribution sampled
    from.  This is used to obtain the dimension and name of the
    distribution; the log density function does not need to be
    specified.}
  \item{sampler.name}{The name of the sampler that generated this
    simulation.  If generated by \pkg{SamplerCompare}, this would
    usually be the \var{name} attribute of the sampler function.}
  \item{X}{A matrix (or object that can be coerced to a matrix)
    containing the simulation results.  It should have one row per
    iteration and one column for each component of the state space.
    Corresponds to the \var{X} element of the list returned by a
    sampler.}
  \item{evals}{The total number of log density evaluations used in
    the simulation; corresponds to the \var{evals} element of the
    list returned by a sampler.}
  \item{grads}{The total number of log density gradient evaluations used in
    the simulation; corresponds to the \var{grads} element of the
    list returned by a sampler.}
  \item{tuning}{The scalar tuning parameter passed to the sampler.}
  \item{cpu}{The processor time used to generate the simulation in seconds.}
  \item{burn.in}{Initial fraction of \var{X} to discard before
    computing autocorrelation times.}
  \item{y}{A vector with the same number of elements as \var{X} has
    rows containing the log densities at the states represented by
    those rows.}
  \item{sampler.expr}{The name of the sampler that generated this
    simulation in \code{\link{plotmath}} format.  If generated by
    \pkg{SamplerCompare}, this would usually be the \var{name.expression}
    attribute of the sampler function.}
  \item{aborted}{A logical scalar indicating whether the simulation
    was prematurely aborted.}
}

\details{
  This function summarizes a simulation into a single-row data frame
  by computing the autocorrelation time of its slowest-mixing
  component and, if possible, the autocorrelation time of the log
  density and the error in the sample mean.  The   autocorrelation
  time of the slowest-mixing component can always be estimated, but
  is more accurate if the true mean is specified in \var{target.dist}.
  The autocorrelation time of the log density can be estimated if
  either the log density function is specified in \var{target.dist}
  or an explicit vector of log densities is passed as \var{y}.  The
  error in the sample mean can be computed if the mean is specified in
  \var{target.dist}.

  This function is intended to be called once per simulation for a
  variety of simulations.  The results are to be combined with
  \code{\link{rbind}} and can be visualized with
  \code{\link{comparison.plot}}.  While the \var{evals} and
  \var{tuning} arguments are optional, the result cannot be used
  with \code{\link{comparison.plot}} if it is not set.
  \code{simulation.result} is normally called internally by
  \code{\link{compare.samplers}} but is exported so that simulations
  run in external systems such as JAGS can be analyzed with
  \pkg{SamplerCompare}.  See the \dQuote{Examples} section for an
  example of this usage.
}

\value{
  A single-row data frame of the format returned by
  \code{\link{compare.samplers}}.
}

\seealso{
  \code{\link{compare.samplers}},
  \code{\link{comparison.plot}},
  \dQuote{Introduction to SamplerCompare} (vignette)
}

\examples{\dontrun{
# An example generated with the following JAGS model:
#
# model {
#   mu[1] <- 0
#   mu[2] <- 0
#   Sigma[1,1] <- 1
#   Sigma[2,2] <- 1
#   Sigma[1,2] <- 0.7
#   Sigma[2,1] <- 0.7
#   x ~ dmnorm(mu, inverse(Sigma))
# }
#
# and the following JAGS script:
#
# model in "mv.7.model"
# compile, nchains(1)
# initialize
# update 1000
# monitor x
# update 10000
# coda *

# Load data written by JAGS

library(coda)
X <- read.coda('CODAchain1.txt', 'CODAindex.txt')

# Dummy distribution object.

N2.dist <- make.dist(2, '2D Normal, cor=0.7', mean=c(0,0))

# Compute simulation result.  evals and tuning are hacks; they
# are undefined with Gibbs sampling.  JAGS can do its own burn-in,
# so set burn.in to zero.

sim.result <- simulation.result(N2.dist, 'JAGS', X,
                                evals=nrow(X)*ncol(X), tuning=1,
                                burn.in=0)
}}
