% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res_national_map.R
\name{res_national_map}
\alias{res_national_map}
\title{Reserve National Map}
\usage{
res_national_map(
  incl = c("contig", "AK", "HI", "PR"),
  highlight_states = NULL,
  highlight_reserves = NULL,
  agg_county = TRUE
)
}
\arguments{
\item{incl}{chr vector to include AK, HI , and PR (case sensitive)}

\item{highlight_states}{chr vector of state FIPS codes}

\item{highlight_reserves}{chr vector of 3 letter reserve codes}

\item{agg_county}{logical, should counties be aggregated to the state-level? Defaults to \code{TRUE}}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Create a base map for NERRS reserves in ggplot
}
\details{
Create a base map of the US with options for including AK, HI, and PR. The user can choose which states and NERRS reserves to highlight. An early 'sp'-based version of this function by Julie Padilla was developed, in part, from a blog post by Bob Rudis. The current {sf}-based version, by Dave Eslinger, uses an approach from  the r-spatial tutorial by Mel Moreno and Mathieu Basille.
}
\examples{
##National map highlighting states with NERRS
nerr_states <- c('01', '02', '06', '10', '12', '13', '15'
, '23', '24', '25', '27', '28', '33', '34', '36', '37', '39'
, '41', '44', '45', '48', '51', '53', '55', '72')

res_national_map(highlight_states = nerr_states)
\donttest{

#' ##Just the national map
res_national_map()

##National map highlighting west coast states and NERRS (including AK)
nerr_states_west <- c('02', '06', '41', '53')

nerrs_codes <- c('pdb', 'sos', 'sfb', 'elk', 'tjr', 'kac')

res_national_map(highlight_states = nerr_states_west, highlight_reserve = nerrs_codes)
}
}
\references{
Rudis, Bob. 2014. "Moving The Earth (well, Alaska & Hawaii) With R". rud.is (blog). November 16, 2014. https://rud.is/b/2014/11/16/moving-the-earth-well-alaska-hawaii-with-r/
Moreno, Mel, and Basille, Mathieu Basille. 2018. "Drawing beautiful maps programmatically with R, sf and ggplot2 — Part 3: Layouts" r-spatial (blog). October 25, 2018. https://www.r-spatial.org/r/2018/10/25/ggplot2-sf-3.html
}
\author{
Julie Padilla, Dave Eslinger
Maintainer: Dave Eslinger
}
\concept{analyze}
