% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{em_lfdr}
\alias{em_lfdr}
\title{EM algorithm to estimate local false discovery rate}
\usage{
em_lfdr(pa_in, pb_in, pi0a_in, pi0b_in)
}
\arguments{
\item{pa_in}{A numeric vector of p-values from study 1.}

\item{pb_in}{A numeric vector of p-values from study 2.}

\item{pi0a_in}{An initial estimate of the null probability in study 1.}

\item{pi0b_in}{An initial estimate of the null probability in study 2.}
}
\value{
\item{Lfdr}{The estimated local false discovery rate for replicability null.}
\item{fdr}{The adjusted values based on local false discovery rate for FDR control.}
\item{xi00}{An estimate of the prior probability for joint state (0, 0).}
\item{xi01}{An estimate of the prior probability for joint state (0, 1).}
\item{xi10}{An estimate of the prior probability for joint state (1, 0).}
\item{xi11}{An estimate of the prior probability for joint state (1, 1).}
\item{f1}{A non-parametric estimate for the non-null probability density function in study 1.}
\item{f2}{A non-parametric estimate for the non-null probability density function in study 2.}
}
\description{
Estimate the local false discovery rate across two studies and apply a step-up procedure to control the FDR of replicability null.
}
