% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssim_bandwidth.R
\name{ssim_bandwidth}
\alias{ssim_bandwidth}
\title{Bandwidth ranges for the SSIM Index for polygon maps.}
\usage{
ssim_bandwidth(
  shape,
  map1,
  map2,
  max_bandwidth = max_bandwidth,
  standardize = TRUE,
  option = "midpoint"
)
}
\arguments{
\item{shape}{A \code{sf} polygon containing the attributes that can create polygon-based maps.}

\item{map1}{The name of the first map to compare as a column in the shape.}

\item{map2}{The name of the second map to compare as a column in the shape.}

\item{max_bandwidth}{Maximum size of the bandwidth, and the maximum size needs to be larger than 12.}

\item{standardize}{If TRUE, standardize the variables before computing the SSIM. Default is TRUE.}

\item{option}{The option for selecting the range of the bandwidth derived from the optimal trade-off between bias and variance. Default is "midpoint."}
}
\value{
A plot showing the bias/variance trade-off and the range of the optimal trade-off as vertical lines including the square root of N results as well.
In addition, the console shows the results.
}
\description{
This function calculates the range of the bandwidth for the SSIM index using the square root of N and optimal trade-off between bias and variance.
}
\details{
This function calculates the bandwidth range for the SSIM index for polygon maps using Gaussian kernel weighting.
The bandwidth is calculated by two methods: 1) the square root of N and 2) the optimal trade-off between bias and variance.
Users can select the bandwidth values from the range of the optimal trade-off, which minimize the trade-off between bias and variance, generated by two maps.
}
\examples{
# Load example sf class object Toronto Area with attributes for maps:
# Pampalon Index,CIMD Index,
# and percentage of household commuting within the same Census Sub-Division of residence.
data("Toronto")

# Mapping two attributes
plot(Toronto$CIMD_SDD)
plot(Toronto$PP_SDD)

# Execution of bandwidth with maps above
\donttest{
ssim_bandwidth(Toronto,"CIMD_SDD","PP_SDD",max_bandwidth=100)
}

}
