% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matlabColon.R
\name{matlabColon}
\alias{matlabColon}
\alias{SeqInc}
\title{Simulate Matlab's ':'}
\usage{
matlabColon(from, to)

SeqInc(from, to)
}
\arguments{
\item{from}{numeric. The start value}

\item{to}{numeric. The end value.}
}
\value{
A numeric vector, possibly empty.
}
\description{
Functions to generate increasing sequences
}
\details{
matlabColon(a,b) returns a:b (R's version) unless a > b, in which case it returns integer(0).
SeqInc(a,b) is similar, but results in error when the calculated length of the sequence (1+to-from) is negative.
}
\examples{
identical(3:5, matlabColon(3, 5)) ## => TRUE
3:1 ## => 3 2 1
matlabColon(3, 1) ## => integer(0)
try(SeqInc(3, 1)) ## => Error
SeqInc(3, 2)      ## => integer(0)
}
\seealso{
\code{\link{seq}}
}
\author{
Bjørn-Helge Mevik (matlabColon) and Øyvind Langsrud (SeqInc)
}
