% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternMatching.R
\name{WildcardGlobbing}
\alias{WildcardGlobbing}
\title{Row selection by wildcard/globbing}
\usage{
WildcardGlobbing(x, wg, sign = TRUE, invert = "!")
}
\arguments{
\item{x}{data.frame with character data}

\item{wg}{data.frame with wildcard/globbing}

\item{sign}{When FALSE, the result is inverted.}

\item{invert}{Character to invert each single selection.}
}
\value{
Logical vector defining subset of rows.
}
\description{
The selected rows match combined requirements for all variables.
}
\details{
This function is used by \code{\link{HierarchicalWildcardGlobbing}}
and \code{\link{WildcardGlobbingVector}} and make use of 
\code{\link{grepl}} and \code{\link{glob2rx}}.
}
\examples{
# Create data input
data(precip)
data(mtcars)
x <- data.frame(car = rownames(mtcars)[rep(1:NROW(mtcars), each = 35)], city = names(precip), 
                stringsAsFactors = FALSE)

# Create globbing/wildcards input
wg <- data.frame(rbind(c("Merc*", "C*"), c("F*", "??????"), c("!?????????*", "!???????*")), 
                 stringsAsFactors = FALSE)
names(wg) <- names(x)

# Select the following combinations:
# - Cars starting with Merc and cities starting with C
# - Cars starting with F and six-letter cities 
# - Cars with less than nine letters and cities with less than seven letters
x[WildcardGlobbing(x, wg), ]
}
\author{
Øyvind Langsrud
}
