% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funMarkovChain.R
\name{tuneRegionModel}
\alias{tuneRegionModel}
\title{tuneRegionModel}
\usage{
tuneRegionModel(
  regionData,
  pops = NULL,
  lower = NULL,
  upper = NULL,
  control = list()
)
}
\arguments{
\item{regionData}{is a data.frame with observations of 3 variables:
\describe{
    \item{\code{data}}{Date, format: "2020-01-22" "2020-01-23" "2020-01-24" "2020-01-25" ...}
    \item{\code{confirmed}}{num  0 0 0 0 0 0 0 0 0 0 ..}
    \item{\code{fatalities}}{fatalities: num  0 0 0 0 0 0 0 0 0 0 ...}
}
and attributes
 - attr(*, "regionName")= chr "Afghanistan/"
 - attr(*, "regionPopulation")= int 38041754}

\item{pops}{evaluated populations}

\item{lower}{lower bounds for spot optimization, @seealso \code{Link{spot}}}

\item{upper}{upper bounds for spot optimization, @seealso \code{Link{spot}}}

\item{control}{spot control list, see controlSpot}
}
\value{
This function returns a list with:
\describe{
	\item{\code{regionName}}{ e.g., "Afghanistan/": List of 7}
	\describe{
	\item{\code{xbest}}{Parameters of the best found solution (matrix).}
	\item{\code{ybest}}{Objective function value of the best found solution (matrix).}
	\item{\code{x}}{Archive of all evaluation parameters (matrix).}
	\item{\code{y}}{Archive of the respective objective function values (matrix).}
	\item{\code{count}}{Number of performed objective function evaluations.}
	\item{\code{msg}}{Message specifying the reason of termination.}
	\item{\code{modelFit}}{The fit of the last build model, i.e., an object returned by the last call to the function specified by \code{control$model}.}
     }
 }
}
\description{
Perform a \code{\link{spot}} run on \code{\link{funMarkovChain}} with region data.
Results can be postprocessed with the function \code{\link{parseTunedRegionModel}}
to extract model and parameter information.
}
\details{
Note: the default number of function evaluations is very low.
}
\examples{
\donttest{
require("SimInf")
require("SPOT")
data <- preprocessInputData(regionTrain, regionPopulation)
a <- c(0.01,  0.001, 0.001,   0.001)
b <- c(0.1,  0.01, 0.01,   0.01)
lapply(data[1], tuneRegionModel, pops=NULL, lower = a, upper = b,
control=list(funEvals=6,
designControl=list(size=5), model = buildLM))
}

}
