#' @title Results from a very simple SPOT run, version 2, with replicates
#'
#' @description  SPOT results.
#'
#' @details Data generated with the following commands:
#' library("SPOTMisc")
#' library("SPOT")
#' kerasConf <- getKerasConf()
#' lower <- c(1e-6, 1e-6, 16,0.6, 1e-9, 10, 6,0.4,0.99,1,1e-8)
#' upper <- c(0.5, 0.5, 512, 1.5, 1e-2, 50, 10,0.999,0.999,10,6e-8)
#' types <- c("numeric",  "numeric",  "integer",  "numeric",  "numeric",
#'            "integer",  "integer",  "numeric",  "numeric",  "integer",
#'            "numeric")
#'
#'
#' kerasConf$verbose <- 0
#' Ninit <- 3 * length(lower)
#' Rinit <- 3
#' replicates <- 3
#'
#' res <- spot(x = NULL,
#'             fun = funKerasMnist,
#'             lower = lower,
#'             upper = upper,
#'             control = list(funEvals=20*length(lower),
#'                            noise = TRUE,
#'                            types = types,
#'                            replicates=replicates,
#'                            designControl = list(replicates = Rinit,
#'                                                 size = Ninit),
#'                            model = buildKriging,
#'                            optimizer = optimLBFGSB,
#'                            modelControl=list(target="ei"),
#'                            plots = TRUE,
#'                            progress = TRUE,
#'                            seedFun = 1,
#'                            seedSPOT = 1),
#'             kConf = kerasConf)
#'
#' @format A list of 9 values
#' \describe{
#'   \item{xbest}{num:}
#'   \item{ybest}{num:}
#'   \item{x}{num}
#'   \item{y}{num}
#'   \item{logInfo}{logi}
#'   \item{count}{int}
#'   \item{msg}{chr}
#'   \item{model fit}{List of 13}
#'   \item{ybestVec}{num}
#'  }
#'
"resKerasMnist02"

