% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildKrigingDACE.R
\name{predict.dace}
\alias{predict.dace}
\title{DACE predictor}
\usage{
\method{predict}{dace}(object, newdata, ...)
}
\arguments{
\item{object}{Kriging model (settings and parameters) of class \code{dace}.}

\item{newdata}{design matrix (\code{x}) to be predicted}

\item{...}{not used}
}
\value{
returns a list with the following elements: 
			\item{\code{f}}{ Predicted response \code{y} at design points \code{x} (always)}
			\item{\code{df}}{ Gradient of response \code{y} at design points \code{x}  (only if: \code{GRAD==TRUE} and \code{mx==1})}
			\item{\code{s}}{ Estimated MSE (only if: \code{MSE==TRUE})}
			\item{\code{ds}}{ Gradient of MSE (only if: \code{GRADMSE==TRUE} and \code{mx==1})}

The user can choose whether to predict only mean or if he is also interested in gradient, mean squared error MSE, or the MSE gradient.
\code{object$GRAD} specifies whether gradient of response should be computed. Even if GRAD is TRUE, the gradient will only be computed in case of a single design point.
\code{MSE} specifies whether estimated MSE of response should be computed.
\code{GRADMSE} specifies whether gradient of MSE should be computed.  Even if GRADMSE is TRUE, the gradient will only be computed in case of a single design point.
}
\description{
Predicts \code{y(x)} for a given DACE model (i.e. as created by \code{\link{buildKrigingDACE}}).
}
\examples{
## Create design points
x <- cbind(runif(20)*15-5,runif(20)*15)
## Compute observations at design points
y <- funSphere(x)
## Create model
fit <- buildKrigingDACE(x,y)
## Create new design
xx <- cbind(runif(20)*15-5,runif(20)*15)
## Predict candidates
y1 <- predict(fit,xx)$y
## Plot residuals
plot(y1 - funSphere(xx))

}
\references{
S.~Lophaven, H.~Nielsen, and J.~Sondergaard.
{DACE---A Matlab Kriging Toolbox}.
Technical Report IMM-REP-2002-12, Informatics and Mathematical
Modelling, Technical University of Denmark, Copenhagen, Denmark, 2002.
}
\seealso{
\code{\link{buildKrigingDACE}}
}
\author{
The authors of the original DACE Matlab toolbox \ 
are Hans Bruun Nielsen, Soren Nymand Lophaven and Jacob Sondergaard. \cr
Additional code for generalization to different models by Tobias Wagner \email{wagner@isf.de}. \cr 
Porting and adaptation to R and further extensions by Martin Zaefferer \email{martin.zaefferer@fh-koeln.de}.
}
\keyword{internal}
