% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infillEI.R
\name{infillEI}
\alias{infillEI}
\title{Expected Improvement Infill Criterion}
\usage{
infillEI(predictionList, model)
}
\arguments{
\item{predictionList}{The results of a predict.model call}

\item{model}{The surrogate model which was used for the prediction}
}
\value{
numeric vector, expected improvement results
}
\description{
Compute the negative of the Expected Improvement of a set of candidate solutions.
Based on mean and standard deviation of a candidate solution,
this estimates the expectation of improvement. Improvement
considers the amount by which the best known value (best observed value)
is exceeded by the candidates.
Expected Improvement infill criterion that can be passed to control$modelControl$infillCriterion 
in order to be used during the optimization in SPOT.
Parameters dont have to be specified as this function is ment to be internally by SPOT.
}
\examples{
\donttest{
spot(,funSphere,c(-2,-3),c(1,2), control = 
    list(infillCriterion = infillEI, modelControl = list(target = c("y","s"))))
    }
}
