% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotTools.R
\name{getNatDesignFromCoded}
\alias{getNatDesignFromCoded}
\title{Get natural parameter values from coded +-1 representation}
\usage{
getNatDesignFromCoded(x, a, b)
}
\arguments{
\item{x}{(n,m)-dim \code{matrix} of coded values, i.e., lower values 
are coded as -1, upper values as +1.}

\item{a}{m-dim \code{vector} of lower bounds (natural values)}

\item{b}{m-dim \code{vector} of upper bounds (natural values)}
}
\description{
For given lower and upper bounds, a and b, respectively,
coded input values are mapped to their natural values
}
\examples{
# Note: donttest is used, because platform x86_64-w64-mingw32 (64-bit) 
# does not provide the package babsim.hospital.
\donttest{ 
require(babsim.hospital)
x <- matrix(rep(-1,29),1,)
bounds <- getBounds()
lower <- bounds$lower
upper <- bounds$upper
getNatDesignFromCoded(x, a = lower, b=upper)
}
}
