% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_mac.R
\name{min_mac}
\alias{min_mac}
\title{Vizualise, filter based on Minor Allele Count (MAC)}
\usage{
min_mac(vcfR, min.mac = NULL)
}
\arguments{
\item{vcfR}{a vcfR object}

\item{min.mac}{an integer specifying the minimum minor allele count for a
SNP to be retained (e.g. 'min.mac=3' would remove all SNPs with a MAC of 2 or less)}
}
\value{
if 'min.mac' is not specified, the allele frequency spectrum is returned.
If 'min.mac' is specified, SNPs falling below the MAC cutoff will be removed,
and the filtered vcfR object will be returned.
}
\description{
This function can be run in two ways: 1) Without 'min.mac' specified. This will return
a folded site frequency spectrum (SFS), without performing any filtering on the vcf file. Or
2) With 'min.mac' specified. This will also print the folded SFS and
show you where your specified min. MAC count falls. It will then return your vcfR object
with SNPs falling below your min. MAC threshold removed.
Note: previous filtering steps (especially removing samples) may have resulted
in invariant SNPs (MAC =0). For this reason it's a good idea to run min_mac(vcfR, min.mac=1)
before using a SNP dataset in downstream analyses.
}
\examples{
min_mac(vcfR=SNPfiltR::vcfR.example)
}
