% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_CH_municipality_inventory.R
\name{import_CH_municipality_inventory}
\alias{import_CH_municipality_inventory}
\title{Import the Swiss Municipality inventory}
\usage{
import_CH_municipality_inventory(file_path)
}
\arguments{
\item{file_path}{Character vector of length one. It contains the file path to
the Swiss municipality inventory XML file.}
}
\value{
A list with two tables in the form of tibble objects.
  \enumerate{\item Municipality mutations. \item Canton mutations}
}
\description{
This function imports the Swiss municipality inventory from the raw XML
resource into R as a \code{\link[tibble]{tibble}}. The imported table is the
basis to map the Swiss municipalities from an old to a new state (see
\code{\link{map_old_to_new_state}}).
}
\details{
This imported Swiss municipality inventory is a database with the complete
mutation history that occured since 01.01.1960. The Swiss municipality inventory is
made available by the Federal Statistical Office and updated regularly to
keep track of new mutations.

\strong{Download}

See BfS webpage for infos about Swiss municipality inventory:
\href{https://www.bfs.admin.ch/bfs/de/home/grundlagen/agvch/historisiertes-gemeindeverzeichnis.assetdetail.11467405.html}{Historisiertes
Gemeindeverzeichnis}

Direct download link:
\href{https://www.bfs.admin.ch/bfsstatic/dam/assets/11467405/master}{Download
XML}
}
\seealso{
\code{\link{map_old_to_new_state}}
}
