% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{FilterModel1}
\alias{FilterModel1}
\title{Filtering algorithm for the type one model.}
\usage{
FilterModel1(mY, mX, mZ, beta, mB = NULL, Omega, vD, U0,
  method = "max_1")
}
\arguments{
\item{mY}{the matrix containing Y_t with dimension \eqn{T \times p}.}

\item{mX}{the matrix containing X_t with dimension \eqn{T \times q_1}.}

\item{mZ}{the matrix containing Z_t with dimension \eqn{T \times q_2}.}

\item{beta}{the \eqn{\beta} matrix.}

\item{mB}{the coefficient matrix \eqn{\boldsymbol{B}} before \code{mZ} with dimension \eqn{p \times q_2}.}

\item{Omega}{covariance matrix of the errors.}

\item{vD}{vector of the diagonals of \eqn{D}.}

\item{U0}{initial value of the alpha sequence.}

\item{method}{a string representing the optimization method from c('max_1','max_2','max_3','min_1','min_2').}
}
\value{
an array \code{aAlpha} containing the modal orientations of alpha in the prediction step.
}
\description{
This function implements the filtering algorithm for the type one model.
See Details part below.
}
\details{
The type one model on Stiefel manifold takes the form:
\deqn{\boldsymbol{y}_t \quad = \quad \boldsymbol{\alpha}_t \boldsymbol{\beta} ' \boldsymbol{x}_t + \boldsymbol{B} \boldsymbol{z}_t + \boldsymbol{\varepsilon}_t}
\deqn{\boldsymbol{\alpha}_{t+1} | \boldsymbol{\alpha}_{t} \quad \sim \quad ML (p, r, \boldsymbol{\alpha}_{t} \boldsymbol{D})}
where \eqn{\boldsymbol{y}_t} is a \eqn{p}-vector of the dependent variable,
\eqn{\boldsymbol{x}_t} and \eqn{\boldsymbol{z}_t} are explanatory variables wit dimension \eqn{q_1} and \eqn{q_2},
\eqn{\boldsymbol{x}_t} and \eqn{\boldsymbol{z}_t} have no overlap,
matrix \eqn{\boldsymbol{B}} is the coefficients for \eqn{\boldsymbol{z}_t},
\eqn{\boldsymbol{\varepsilon}_t} is the error vector.

The matrices \eqn{\boldsymbol{\alpha}_t} and \eqn{\boldsymbol{\beta}} have dimensions \eqn{p \times r} and \eqn{q_1 \times r}, respectively.
Note that \eqn{r} is strictly smaller than both \eqn{p} and \eqn{q_1}.
\eqn{\boldsymbol{\alpha}_t} and \eqn{\boldsymbol{\beta}} are both non-singular matrices.
\eqn{\boldsymbol{\alpha}_t} is time-varying while \eqn{\boldsymbol{\beta}} is time-invariant.

Furthermore, \eqn{\boldsymbol{\alpha}_t} fulfills the condition \eqn{\boldsymbol{\alpha}_t' \boldsymbol{\alpha}_t = \boldsymbol{I}_r},
and therefor it evolves on the Stiefel manifold.

\eqn{ML (p, r, \boldsymbol{\alpha}_{t} \boldsymbol{D})} denotes the Matrix Langevin distribution or matrix von Mises-Fisher distribution on the Stiefel manifold.
Its density function takes the form
\deqn{f(\boldsymbol{\alpha_{t+1}} ) = \frac{ \mathrm{etr} \left\{ \boldsymbol{D} \boldsymbol{\alpha}_{t}' \boldsymbol{\alpha_{t+1}} \right\} }{ _{0}F_1 (\frac{p}{2}; \frac{1}{4}\boldsymbol{D}^2 ) }}
where \eqn{\mathrm{etr}} denotes \eqn{\mathrm{exp}(\mathrm{tr}())},
and \eqn{_{0}F_1 (\frac{p}{2}; \frac{1}{4}\boldsymbol{D}^2 )} is the (0,1)-type hypergeometric function for matrix.
}
\examples{

iT = 50
ip = 2
ir = 1
iqx = 4
iqz=0
ik = 0
Omega = diag(ip)*.1

if(iqx==0) mX=NULL else mX = matrix(rnorm(iT*iqx),iT, iqx)
if(iqz==0) mZ=NULL else mZ = matrix(rnorm(iT*iqz),iT, iqz)
if(ik==0) mY=NULL else mY = matrix(0, ik, ip)

alpha_0 = matrix(c(runif_sm(num=1,ip=ip,ir=ir)), ip, ir)
beta = matrix(c(runif_sm(num=1,ip=ip*ik+iqx,ir=ir)), ip*ik+iqx, ir)
mB=NULL
vD = 100

ret = SimModel1(iT=iT, mX=mX, mZ=mZ, mY=mY, alpha_0=alpha_0, beta=beta, mB=mB, vD=vD, Omega=Omega)
mYY=as.matrix(ret$dData[,1:ip])
fil = FilterModel1(mY=mYY, mX=mX, mZ=mZ, beta=beta, mB=mB, Omega=Omega, vD=vD, U0=alpha_0)

}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{filtering}
