% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chksea.R
\name{chksea}
\alias{chksea}
\title{Check the Seasonality of Each Component of a Multiple Time Series}
\usage{
chksea(x, period = c(12), p = 0, alpha = 0.05, output = TRUE)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{period}{seasonal period. Default value is 12.}

\item{p}{Regular AR order. Default value is max(floor(log(T)),1).}

\item{alpha}{Type-I error for the t-ratio of seasonal coefficients. Default value is 0.05.}

\item{output}{If TRUE it returns if the series has seasonality. Default is TRUE.}
}
\value{
A list containing:
\itemize{
   \item Seasonal - TRUE or FALSE.
   \item period - Seasonal period.
}
}
\description{
Check the seasonality of each component of a multiple time series.
}
\details{
Check the seasonality fitting a seasonal AR(1) model and a regular AR(p) model to a scalar
time series and testing if the estimated seasonal AR coefficient is significant.
}
\examples{
data(TaiwanAirBox032017)
output <- chksea(TaiwanAirBox032017[,1])
}
