% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCCmatrix.R
\name{GCCmatrix}
\alias{GCCmatrix}
\title{Generalized Cross-Correlation Matrix}
\usage{
GCCmatrix(x, lag, model, lag.set)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{lag}{Selected lag for computing the GCC between the pairs of series.
Default value is computed inside the program.}

\item{model}{Model specification. When the value lag is unknown for the user,
the model specification is chosen between GARCH model or AR model. Default is ARMA model.}

\item{lag.set}{If lag is not specified and the user wants to use instead of lags from 1 to 'lag' a non consecutive set of lags they can be defined as lag.set = c(1, 4, 7).}
}
\value{
A list containing:
\itemize{
\item DM - A matrix object with the distance matrix.
\item k_GCC - The lag used to calculate GCC measure.
}
}
\description{
Built the GCC similarity matrix between time series proposed in Alonso and Peña (2019).
}
\examples{
data(TaiwanAirBox032017)
output <- GCCmatrix(TaiwanAirBox032017[,1:3])

}
\references{
Alonso, A. M. and Peña, D. (2019). Clustering time series by linear
dependency. \emph{Statistics and Computing}, 29(4):655–676.
}
