% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arimaID.R
\name{arimaID}
\alias{arimaID}
\title{Automatic Modeling of a Scalar Time Series}
\usage{
arimaID(
  zt,
  maxorder = c(5, 1, 3),
  criterion = "bic",
  period = c(12),
  output = TRUE,
  method = "CSS-ML",
  pv = 0.01,
  spv = 0.01,
  transpv = 0.05,
  nblock = 0
)
}
\arguments{
\item{zt}{T by 1 vector of an observed scalar time series without any missing values.}

\item{maxorder}{Maximum order of \eqn{(p,d,q)} where \eqn{p} is the AR order, \eqn{d} the degree of differencing,
and \eqn{q} the MA order. Default value is (5,1,4).}

\item{criterion}{Information criterion used for model selection. Either AIC or BIC.
Default is "bic".}

\item{period}{Seasonal period. Default value is 12.}

\item{output}{If TRUE it returns the differencing order, the selected order and the minimum
value of the criterion. Default is TRUE.}

\item{method}{Estimation method. See the arima command in R. Possible values are "CSS-ML", "ML", and "CSS".
Default is "CSS-ML".}

\item{pv}{P-value for unit-root test. Default value is 0.01.}

\item{spv}{P-value for detecting seasonality. Default value is 0.01.}

\item{transpv}{P-value for checking non-linear transformation. Default value is 0.05.}

\item{nblock}{Number of blocks used in checking non-linear transformations. Default value is floor(sqrt(T)).}
}
\value{
A list containing:
\itemize{
   \item data - The time series. If any non-linear transformation is taken, "data" is the transformed series.
   \item order - Regular ARIMA order.
   \item sorder - Seasonal ARIMA order.
   \item period - Seasonal period.
   \item include.mean - Switch concerning the inclusion of mean in the model.
}
}
\description{
Automatic selection and estimation of a regular or possibly seasonal ARIMA model for a given time series.
}
\details{
The program follows the following steps:
\itemize{
\item Check for seasonality: fitting a multiplicative ARIMA(p,0,0)(1,0,0)_s model to a scalar time
series and testing if the estimated seasonal AR coefficient is significant.
\item Check for non-linear transformation: the series is divided into a given number of consecutive blocks and in each
of them the Mean Absolute Deviation (MAD) and the median is computed. A regression of the log of the
MAD with respect to the log of the median is run and the slope defines the non-linear transformation.
\item Select orders: maximum order of \eqn{(p,d,q)}.
}
}
\examples{
data(TaiwanAirBox032017)
fit <- arimaID(TaiwanAirBox032017[,1])

}
