% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryccm.R
\name{Summaryccm}
\alias{Summaryccm}
\title{Summary Statistics of Cross-Correlation Matrices}
\usage{
Summaryccm(x, max.lag = 12)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{max.lag}{The number of lags for CCM.}
}
\value{
A list containing:
\itemize{
\item pvalue - P-values of Chi-square tests of individual-lag CCM being zero-matrix.
\item ndiag - Percentage of significant diagonal elements for each lag.
\item noff - Percentage of significant off-diagonal elements for each lag.
}
}
\description{
Compute and plot summary statistics of cross-correlation matrices (CCM) for high-dimensional time series.
}
\examples{
data(TaiwanAirBox032017)
output <- Summaryccm(as.matrix(TaiwanAirBox032017[,1:4]))

}
