% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keggInteractome.R
\docType{data}
\name{kegg}
\alias{kegg}
\title{KEGG interactome}
\format{
"kegg" is an igraph network object of 5143 nodes and 43734 edges 
(40424 directed and 3310/2 = 1655 bidirected) corresponding to the
union of 227 KEGG pathways.
}
\source{
\url{https://www.genome.jp/kegg/}
}
\usage{
kegg
}
\description{
Interactome generated by merging KEGG pathways 
extracted using the \code{ROntoTools} R package (update: November, 2021).
}
\examples{

# KEGG graph
summary(kegg)

# KEGG degrees of freedom
vcount(kegg)*(vcount(kegg) - 1)/2 - ecount(kegg)

}
\references{
Kanehisa M, Goto S (1999). KEGG: kyoto encyclopedia of genes and genomes. 
Nucleic Acid Research 28(1): 27-30. 
<https://doi.org/10.1093/nar/27.1.29>

Calin Voichita, Sahar Ansari and Sorin Draghici (2023).
ROntoTools: R Onto-Tools suite. R package version 2.30.0.
}
