% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semPaths.R
\name{pathFinder}
\alias{pathFinder}
\title{Perturbed path search utility}
\usage{
pathFinder(
  graph,
  data,
  group = NULL,
  ace = NULL,
  path = "directed",
  method = "none",
  alpha = 0.05,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{graph}{Input network as an igraph object.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes (variables).}

\item{group}{group A binary vector. This vector must be as long as the
number of subjects. Each vector element must be 1 for cases and 0
for control subjects. Group specification enables edge perturbation
testing. By default, \code{group = NULL}.}

\item{ace}{A data.frame generated by \code{\link[SEMgraph]{SEMace}}.
If NULL, \code{\link[SEMgraph]{SEMace}} will be automatically run.}

\item{path}{If \code{path = "directed"}, all directed paths between
the two nodes will be included in the fitted model.
If \code{path = "shortest"}, only shortest paths will be considered.}

\item{method}{Multiple testing correction method. One of the values
available in \code{\link[stats]{p.adjust}}.
By default, \code{method = "none"} (i.e., no multiple test correction).}

\item{alpha}{Significance level for ACE selection (by default,
\code{alpha = 0.05}).}

\item{verbose}{Show the significant directed (or shortest) paths
inside the input graph.}

\item{...}{Currently ignored.}
}
\value{
A list of 3 objects:
\itemize{
\item "paths", list of paths as igraph objects;
\item "fit", fitting results for each path as a lavaan object;
\item "dfp", a data.frame containing SEM global fitting statistics.
}
}
\description{
This function uses \code{\link[SEMgraph]{SEMace}} to find
significant causal effects between source-sink pairs and
\code{\link[SEMgraph]{SEMpath}} to fit them and test their edge
perturbation.
}
\examples{

\donttest{

# Find and evaluate significantly perturbed paths

library(huge)
als.npn <- huge.npn(alsData$exprs)

adjData <- SEMbap(graph = alsData$graph, data = als.npn)$data

ace <- SEMace(graph = alsData$graph, data = adjData,
              group = alsData$group)
ace <- ace[order(ace$pvalue),]
print(ace)

paths <- pathFinder(graph = alsData$graph, data = adjData,
                    group = alsData$group,
                    ace = ace)

head(parameterEstimates(paths$fit$P19))
gplot(paths$paths$P19)

path19 <- SEMpath(graph = alsData$graph, data = adjData,
                  group = alsData$group,
                  from = "7133",
                  to = "4747",
                  path = "directed",
                  verbose = TRUE)

}

}
\author{
Fernando Palluzzi \email{fernando.palluzzi@gmail.com}
}
