% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{SEAGLE}
\alias{SEAGLE}
\title{Compute score-like test statistic and p-value for GxE test with SEAGLE algorithm}
\usage{
SEAGLE(obj.SEAGLE, init.tau = 0.5, init.sigma = 0.5, pv = "liu")
}
\arguments{
\item{obj.SEAGLE}{Input data prepared with prep.SEAGLE function}

\item{init.tau}{Initial estimate for tau (Default is 0.5)}

\item{init.sigma}{Initial estimate for sigma (Default is 0.5)}

\item{pv}{Method of obtaining p-value (Either "liu" or "davies", Default is liu)}
}
\value{
Score-like test statistic T for the GxE effect and corresponding p-value
}
\description{
This function computes the score test statistic and corresponding
p-value for the GxE test with the SEAGLE algorithm with input data
that have been prepared with the prep.SEAGLE function
}
\examples{
dat <- makeSimData(H=cosihap, n=500, L=10, gammaG=1, gammaGE=0, causal=4, seed=1)
objSEAGLE <- prep.SEAGLE(y=dat$y, X=dat$X, intercept=1, E=dat$E, G=dat$G)
res <- SEAGLE(objSEAGLE, init.tau=0.5, init.sigma=0.5)

}
