% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinData.R
\name{thinData}
\alias{thinData}
\title{Thin Data}
\usage{
thinData(coords, env)
}
\arguments{
\item{coords}{data.frame or matrix with the coordinates.}

\item{env}{\code{\link[raster]{stack}} containing the environmental
variables, or a single \code{\link[raster]{raster}} layer.}
}
\value{
a data frame with the thinned locations.
}
\description{
Remove all but one location per raster cell. The function removes NAs and if
more than one location falls within the same raster cell it selects randomly
one.
}
\details{
\strong{coords} and \strong{env} must have the same coordinate reference
system.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 9000)

nrow(bg_coords)

# Thin the locations
thinned_bg <- thinData(bg_coords, env = predictors)
nrow(thinned_bg)
}
\author{
Sergio Vignali
}
