% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plotROC}
\alias{plotROC}
\title{Plot ROC curve}
\usage{
plotROC(model, test = NULL, val = NULL)
}
\arguments{
\item{model}{\code{\link{SDMmodel}} object.}

\item{test}{\code{\link{SWD}} object. The testing dataset, default is
\code{NULL}.}

\item{val}{deprecated.}
}
\value{
The plot object.
}
\description{
Plot the ROC curve of the given model and print the AUC value.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data, test = 0.2, only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", data = train, fc = "l")

# Plot the training ROC curve
plotROC(model)

# Plot the training and testing  ROC curves
plotROC(model, test = test)
}

}
\author{
Sergio Vignali
}
