% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_kmz.R
\name{to_kmz}
\alias{to_kmz}
\title{Generate KMZ from locations and track}
\usage{
to_kmz(sdata, crs = 4326, file.name = "id", ...)
}
\arguments{
\item{sdata}{A data frame containing location data of \bold{one} individual, 
with the following column headers: "id", "DateTime", "lat", "lon". 
"id" is an identifier of the individual. 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} 
or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the latitude and longitude of each location in decimal degrees.}

\item{crs}{A number specifying the European Petroleum Survey Group (EPSG) code for the input location data.}

\item{file.name}{A character specifying the output file name.}

\item{...}{Optional arguments passed to \code{\link[plotKML]{kml_layer}} for points.}
}
\value{
A kmz file
}
\description{
Function to generate a kmz file from tracking data. 
This is a wrapper of \code{\link[plotKML]{kml}}, 
specifically designed to generate a kmz file from tracking data.
}
\examples{
## Tracking data of two green turtles
data(turtle); data(turtle2)

## Filter data
d1 <- ddfilter(dupfilter(turtle))
d2 <- ddfilter(dupfilter(turtle2))

## Combine two data
d <- list(d1, d2) 

\dontrun{
## Generate a kmz file from each tracking data
shp <- 'http://maps.google.com/mapfiles/kml/pal2/icon18.png'
for(i in 1:2){
  # labels for points (date and time)
  pn <- d[[i]]$DateTime
  
  # Apply a colour gradient to points based on the date and time
  pt_col <- hcl.colors(n = nrow(d[[i]]), palette = 'Zissou 1')
 
  # Generate a kmz file
  to_kmz(d[[i]], shape = shp, colour_scale = pt_col, colour = pn, points_names = pn, LabelScale = 0)
 }
}
}
\seealso{
\code{\link{map_track}}
}
\author{
Takahiro Shimada
}
