% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmaxlp.R
\name{vmaxlp}
\alias{vmaxlp}
\title{Estimate maximum one-way linear speed of a loop trip}
\usage{
vmaxlp(sdata, qi = 4, prob = 0.99, ...)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
See the data \code{\link{turtle}} for an example.
The function filters the input data by a unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} or 
\code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the quality index associated with each location fix. 
The input values can be either the number of GPS satellites or Argos Location Classes. 
Argos Location Classes will be converted to numerical values, where "A", "B", "Z" will be replaced with "-1", "-2", "-3" respectively.
The greater number indicates a higher accuracy.}

\item{qi}{An integer specifying the minimum quality index associated with a location used for the estimation. 
Default is 4 (e.g. 4 GPS satellite or more).}

\item{prob}{A numeric value to specify a sample quantile. Default is 0.99.}

\item{...}{Extra arguments passed to \code{\link{dupfilter}}.}
}
\value{
Maximum one-way linear speed of a loop trip (vmaxlp) estimated from the input data. The unit km/h.
}
\description{
Function to estimate the maximum one-way linear speed of a loop trip as described in 
\href{https://www.int-res.com/abstracts/meps/v457/p171-180/}{Shimada et al. (2012)}.
}
\details{
The function first detects a "loop trip". 
Loop trip behaviour is represented by spatial departure and return involving more than 3 consecutive locations 
\href{https://www.int-res.com/abstracts/meps/v457/p171-180/}{(Shimada et al. 2012)}. 
The function calculates the net (i.e. straight-line) distance between the departure and turning point as well as 
the turning point and return location of a loop trip. 
It then calculates the one-way travelling speed to or from each turning point for each loop trip. 
The function discards extreme values, based on the specified quantile, to exclude potential outliers from the estimation process.
The maximum value in the retained dataset (i.e. without outliers) represents the maximum one-way linear speed at which 
an animal would travel during a loop trip.
}
\note{
The input data must not contain temporal or spatial duplicates. A minimum of 8 locations are required.
}
\references{
Shimada T, Jones R, Limpus C, Hamann M (2012) 
Improving data retention and home range estimates by data-driven screening. 
\emph{Marine Ecology Progress Series} 457:171-180 \doi{10.3354/meps09747}
}
\seealso{
\code{\link{ddfilter}}, \code{\link{ddfilter_loop}}, \code{\link{track_param}}, \code{\link{dupfilter}}
}
\author{
Takahiro Shimada
}
