#' @aliases ud_raster
#' @title A list of raster data containing probability distributions of flatback turtles
#' @description Inter-nesting utilisation distributions of 15 flatback turtles (/emph{Natator depressus}) that nested in Curtis Island, Australia.
#' The UDs were calculated using the sample tracking data /code{/link{flatback}} and reduced grid resolution (1 km)
#' instead of 50m as used in /href{https://besjournals.onlinelibrary.wiley.com/doi/10.1111/2041-210X.13506}{Shimada et al. (2021)}.
#' See /href{https://github.com/TakahiroShimada/SDLfilter}{GitHub} for an example code of UD estimation.
#' @format A list of 15 stars objects
#' @source Shimada T, Thums M, Hamann M, Limpus CJ, Hays GC, FitzSimmons N, Wildermann NE, Duarte CD, Meekan MG (2021) 
#' Optimising sample sizes for animal distribution analysis using tracking data. 
#' /emph{Methods in Ecology and Evolution} 12(2):288-297 /doi{10.1111/2041-210X.13506}
"ud_raster"