% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MESDIF.R
\name{MESDIF}
\alias{MESDIF}
\title{Multiobjective Evolutionary Subgroup DIscovery Fuzzy rules (MESDIF) Algorithm}
\usage{
MESDIF(paramFile = NULL, training = NULL, test = NULL,
  output = c("optionsFile.txt", "rulesFile.txt", "testQM.txt"), seed = 0,
  nLabels = 3, nEval = 10000, popLength = 100, eliteLength = 3,
  crossProb = 0.6, mutProb = 0.01, RulesRep = "can", Obj1 = "CSUP",
  Obj2 = "CCNF", Obj3 = "null", Obj4 = "null", targetVariable = NA,
  targetClass = "null")
}
\arguments{
\item{paramFile}{The path of the parameters file. \code{NULL} If you want to use training and test \code{SDEFSR_Dataset} variables}

\item{training}{A \code{SDEFSR_Dataset} class variable with training data.}

\item{test}{A \code{SDEFSR_Dataset} class variable with test data. \code{NULL} if you only want to use training data.}

\item{output}{character vector with the paths where store information file, rules file and quality measures file, respectively.}

\item{seed}{An integer to set the seed used for generate random numbers.}

\item{nLabels}{Number of linguistic labels that represents numerical variables.}

\item{nEval}{An integer for set the maximum number of evaluations in the evolutive process. Large values of this parameter increments the computing time.}

\item{popLength}{An integer to set the number of individuals in the population.}

\item{eliteLength}{An integer to set the number of individuals in the elite population.}

\item{crossProb}{Sets the crossover probability. A number in [0,1].}

\item{mutProb}{Sets the mutation probability. A number in [0,1].}

\item{RulesRep}{Representation used in the rules. "can" for canonical rules, "dnf" for DNF rules.}

\item{Obj1}{Sets the Objective number 1. See \code{Objective values} for more information about the possible values.}

\item{Obj2}{Sets the Objective number 2. See \code{Objective values} for more information about the possible values.}

\item{Obj3}{Sets the Objective number 3. See \code{Objective values} for more information about the possible values.}

\item{Obj4}{Sets the Objective number 4. See \code{Objective values} for more information about the possible values.}

\item{targetVariable}{The name or index position of the target variable (or class). It must be a categorical one.}

\item{targetClass}{A string specifing the value of the target variable. \code{null} for search for all possible values.}
}
\value{
The algorithm shows in the console the following results:
\enumerate{
 \item The parameters used in the algorithm
 \item The rules generated.
 \item The quality measures for test of every rule and the global results. This globals results shows the number of 
      rules generated and means results for each quality measure.
}

Also, the algorithms save those results in the files specified in the \code{output} parameter of the algorithm or 
in the \code{outputData} parameter in the parameters file.
    
Additionally a \code{SDEFSR_Rules} object is returned with this information.
}
\description{
Performs a subgroup discovery task executing the MESDIF algorithm.
}
\details{
This function sets as target variable the last one that appear in \code{SDEFSR_Dataset} object. If you want 
    to change the target variable, you can set the \code{targetVariable} to change this target variable.
    The target variable MUST be categorical, if it is not, throws an error. Also, the default behaviour is to find
    rules for all possible values of the target varaible. \code{targetClass} sets a value of the target variable where the
    algorithm only finds rules about this value.
    
    If you specify in \code{paramFile} something distinct to \code{NULL} the rest of the parameters are
    ignored and the algorithm tries to read the file specified. See "Parameters file structure" below 
    if you want to use a parameters file.
}
\section{How does this algorithm work?}{

  This algorithm performs a multi-objective genetic algorithm based on elitism (following the SPEA2 approach). The elite population has 
  a fixed size and it is filled by non-dominated individuals.
  
  An individual is non-dominated when \code{(! all(ObjI1 <= ObjI2) & any(ObjI1 < ObjI2))} where ObjI1
  is the objective value for our individual and ObjI2 is the objetive value for another individual.
  The number of dominated individuals by each one determine, in addition with a niches technique that considers
  the proximity among values of the objectives a fitness value for the selection.
  
  The number of non-dominated individuals might be greater or less than elite population size and in those cases
  MESDIF implements a truncation operator and a fill operator respectively. Then, genetic operators are
  applied.
  
  At the final of the evolutive process it returns the rules stored in elite population. Therefore, the number of rules is fixed with the \code{eliteLength} parameter.
}

\section{Parameters file structure}{

  The \code{paramFile} argument points to a file which has the necesary parameters for MESDIF works.
  This file \strong{must} have, at least, those parameters (separated by a carriage return):
  \itemize{
    \item \code{algorithm}  Specify the algorithm to execute. In this case. "MESDIF"
    \item \code{inputData}  Specify two paths of KEEL files for training and test. In case of specify only the name of the file, the path will be the working directory.
    \item \code{seed}  Sets the seed for the random number generator
    \item \code{nLabels}  Sets the number of fuzzy labels to create when reading the files
    \item \code{nEval}  Set the maximun number of \strong{evaluations of rules} for stop the genetic process
    \item \code{popLength}  Sets number of individuals of the main population
    \item \code{eliteLength}  Sets number of individuals of the elite population. Must be less than \code{popLength}  
    \item \code{crossProb}  Crossover probability of the genetic algorithm. Value in [0,1]
    \item \code{mutProb}  Mutation probability of the genetic algorithm. Value in [0,1]
    \item \code{Obj1} Sets the objective number 1. 
    \item \code{Obj2} Sets the objective number 2. 
    \item \code{Obj3} Sets the objective number 3. 
    \item \code{Obj4} Sets the objective number 4.
    \item \code{RulesRep}  Representation of each chromosome of the population. "can" for canonical representation. "dnf" for DNF representation.
    \item \code{targetVariable} The name or index position of the target variable (or class). It must be a categorical one.
    \item \code{targetClass}  Value of the target variable to search for subgroups. The target variable \strong{is always the last variable.} Use \code{null} to search for every value of the target variable
  }
  
  An example of parameter file could be:
 \preformatted{
 algorithm = MESDIF
 inputData = "irisd-10-1tra.dat" "irisd-10-1tst.dat"
 outputData = "irisD-10-1-INFO.txt" "irisD-10-1-Rules.txt" "irisD-10-1-TestMeasures.txt"
 seed = 0
 nLabels = 3
 nEval = 500
 popLength = 100
 eliteLength = 3
 crossProb = 0.6
 mutProb = 0.01
 RulesRep = can
 Obj1 = comp
 Obj2 = unus
 Obj3 = null
 Obj4 = null
 targetClass = Iris-setosa }

  @section Objective values:
     You can use the following quality measures in the ObjX value of the parameter file using this values:
      \itemize{
        \item Unusualness -> \code{unus}
        \item Crisp Support -> \code{csup}
        \item Crisp Confidence -> \code{ccnf}
        \item Fuzzy Support -> \code{fsup}
        \item Fuzzy Confidence -> \code{fcnf}
        \item Coverage -> \code{cove}
        \item Significance -> \code{sign}
      }
    
    If you dont want to use a objective value you must specify \code{null}
}
\examples{
 MESDIF( paramFile = NULL,
        training = habermanTra, 
        test = habermanTst, 
        output = c("optionsFile.txt", "rulesFile.txt", "testQM.txt"),
        seed = 0, 
        nLabels = 3,
        nEval = 300, 
        popLength = 100, 
        eliteLength = 3,
        crossProb = 0.6,
        mutProb = 0.01, 
        RulesRep = "can",
        Obj1 = "CSUP", 
        Obj2 = "CCNF",
        Obj3 = "null",
        Obj4 = "null",
        targetClass = "positive"
        )

\dontrun{
Execution for all classes, see 'targetClass' parameter
MESDIF( paramFile = NULL,
        training = habermanTra, 
        test = habermanTst, 
        output = c("optionsFile.txt", "rulesFile.txt", "testQM.txt"),
        seed = 0, 
        nLabels = 3,
        nEval = 300, 
        popLength = 100, 
        eliteLength = 3,
        crossProb = 0.6,
        mutProb = 0.01, 
        RulesRep = "can",
        Obj1 = "CSUP", 
        Obj2 = "CCNF",
        Obj3 = "null",
        Obj4 = "null",
        targetClass = "null"
        )
 }

}
\references{
\itemize{
 \item Berlanga, F., Del Jesus, M., Gonzalez, P., Herrera, F., & Mesonero, M. (2006). Multiobjective Evolutionary Induction of Subgroup Discovery Fuzzy Rules: A Case Study in Marketing.
 \item Zitzler, E., Laumanns, M., & Thiele, L. (2001). SPEA2: Improving the Strength Pareto Evolutionary Algorithm. 
}
}

