\name{strata-class}
\docType{class}
\alias{strata-class}
\alias{strata}
\alias{summary, strata-method}
\title{Class "strata"}
\description{
The SDAR package introduces a new S4 object class called \link{strata} to define the representation
of stratigraphy and sedimentological data. This S4 class gives a rigorous definition of a stratigraphy
object; a valid object of this S4 class must meet all the requirements specified in the class definition
(e.g., the names of the columns must be called: bed_number, base, top, rock_type, prim_litho, and grain_size.
Also, the base and top must be numeric).
This class automatically validates the inputted dataset and returns a stratigraphy class object.
}
\usage{
strata(x, datum="top")
}
\arguments{
  \item{x}{an object (e.g, \link{data.frame}) with stratigraphic and sedimentological information to be validated;
           in the \emph{Slots} section below, see the requirements of this class.}
  \item{datum}{string; either 'base' or 'top', case sensitive. 'base' is the case when thickness 
               is measured up from the bottom of, e.g., an outcrop section; 'top' is the case when depths are 
               measured down from the surface, e.g., boreholes and cores.}
}
\section{Objects from the Class}{
         Objects of this class represents basic stratigraphic and sedimentological information for the standardization 
         and construction of a comprehensive graphic log (Johnson, 1992).
}
\section{Slots}{
  \describe{
    \item{\code{.Data}:}{object of class \link{data.frame}, which holds the minimum required data to draw a lithological
     profile in SDAR.\cr
     \bold{bed_number:} numeric; it is useful to give a unique index to each bed/layer to facilitate later reference;
          numbering should begin at the stratigraphically lowest bed.\cr
     \bold{base:} numeric; stratigraphic position measured at the bottom of the layer.\cr
     \bold{top:} numeric; stratigraphic position measured at the top of the layer. \emph{Base and top} defines the
          thickness of each bed/layer, overlapping between layers is not allowed.\cr
     \bold{rock_type:} string; must include only one of these values: sedimentary, igneous or covered.\cr
     \bold{prim_litho:} string; description of the primary (i.e., predominant) lithology; must include only one of
          the values listed in table 2 (see \emph{Primary lithology} in vignettes). (e.g., \emph{claystone, siltstone, mudstone, 
          shale, sandstone, conglomerate}), more lithology patterns will be provided at next SDAR version.\cr
     \bold{grain_size:} 
          string; description of the grain size dominant in the layer; must include only one of the values listed in table 3 (see \emph{Grain size} in vignettes). (e.g., \emph{mud, silt; very fine sand, fine sand, medium sand, coarse sand, and very coarse sand}). For siliciclastic rocks it is based on the Wentworth (1922) classification system, for carbonate rocks it is based on Dunham (1962), and for classification of pyroclastic rocks it is based on Wentworth and Williams (1932), and it is represented by the width of the lithological profile (\emph{x-axis}) (Miall 1999, Fig. 2.25). In graphic logs generated by \link{SDAR}, grain size is indicated by the graphic scale at the header of the lithological profile.
     }
  }
}
\section{Extends}{
Class \code{"\linkS4class{data.frame}"}, directly.\cr
Class \code{"\linkS4class{list}"}, by class "data.frame", distance 2.
}
\section{Methods}{
  \describe{
    \item{plot}{\code{signature(object = "strata")}}
    \item{summary}{\code{signature(object = "strata")}}
	 }
}
\author{
John Ortiz
}
\references{
Dunham, R. 1962. \emph{American Association of Petroleum Geologists Memoir. Classification of carbonate rocks according to 
depositional texture.} In Ham, W.E. Classification of carbonate rocks, \bold{1}, 108-121

Miall, A.D., 1999. \emph{Principles of Sedimentary Basin Analysis}, \bold{third edition}, Springer, New York, 616 pp.

Johnson, M.R. 1992. \emph{A proposed format for general-purpose comprehensive graphic logs}. Sedimentary Geology,
\bold{Volume 81, Issues 3-4}, Pages 289-298, ISSN 0037-0738.\cr
\url{https://www.sciencedirect.com/science/article/pii/0037073892900764}

Wentworth, C.K. 1922. \emph{A scale of grade and class terms for clastic sediments}. Journal of Geology, \bold{30}, 377-392.

Wentworth, C.K. and Williams, H. 1932. \emph{Classification and terminology of pyroclastic rocks.} National Research
Council Bulletin, \bold{89}, 19-53.
}

\examples{
data(saltarin)
saltarin_val <- strata(saltarin, datum="top")
class(saltarin_val)
}
\keyword{classes}