## ---- echo = FALSE, message = FALSE--------------------------------------
knitr::opts_chunk$set(collapse = T, comment = "#>")
options(tibble.print_min = 4L, tibble.print_max = 4L)
library(SDAR)

## ------------------------------------------------------------------------
library(SDAR)
data(saltarin)   # load saltarin dataset
nrow(saltarin)   # number of rock layers
names(saltarin)  # variable names of composition and texture description of each layer

## ------------------------------------------------------------------------
# strata function automatically validates the inputted dataset
# and returns a stratigraphy class object.

val.beds.salt <- strata(saltarin)

# check the class of the object generated by the strata function
class(val.beds.salt)

## ---- eval = FALSE-------------------------------------------------------
#  # Code to generate example presented in Figure 1.
#  
#  library(SDAR)                           # load SDAR library
#  data(saltarin)                          # load Saltarin dataset
#  val.beds.salt <- strata(saltarin)       # validated input data
#  plot(val.beds.salt, datum="top")        # plot a stratigraphic log with the SDAR default options

## ---- eval = FALSE-------------------------------------------------------
#  # Code to generate example presented in Figure 2.
#  
#  plot(val.beds.salt, datum="top", d.scale=500, d.barscale=5, data.units="meters",
#  	subset.base=80, subset.top=0, file.name="saltarin_well_SDAR_demo",
#      oil.stain=data.oilstain, bioturbation=data.bio, GR.log=data.log, xlim.GR = c(0, 350),
#      main="Graphic log of Saltarin-1A well", sub="Description scale 1:500")

## ---- eval = FALSE-------------------------------------------------------
#  # Code to generate example presented in Figure 3.
#  
#  plot(val.beds.salt, datum="top", d.scale=500, d.barscale=5, data.units="meters",
#  	subset.base=50, subset.top=0, file.name="saltarin_well_SDAR_symbols",
#      oil.stain=oil.stain, bioturbation=data.bio, GR.log=registro, xlim.GR = c(0, 350),
#      main="Graphic log of Saltarin-1A well", sub="Description scale 1:500",
#      fossils=data.fos, sed.structures=data.sed, tracefossils=data.trace,
#      other.sym=data.other, samples=data.samples, ncore=data.ncore,
#      lithostrat=data.lithostrat, struct.data=data.struct)

## ------------------------------------------------------------------------
library(SDAR)
data(saltarin)
saltarin_val <- strata(saltarin)  # input data validation
summary(saltarin_val)
summary(saltarin_val, grain.size=TRUE)

