% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_functions.R
\name{SDALGCPPred_ST2}
\alias{SDALGCPPred_ST2}
\title{Spatial prediction using plug-in of MCML estimates}
\usage{
SDALGCPPred_ST2(
  para_est,
  cellsize,
  continuous = TRUE,
  control.mcmc = NULL,
  pred.loc = NULL,
  divisor = 1,
  plot.correlogram = F,
  messages = TRUE,
  parallel = FALSE,
  n.window = 1
)
}
\arguments{
\item{para_est}{an object of class "SDALGCPST" obtained as a result of a call to \code{\link{SDALGCPMCML_ST}}.}

\item{cellsize}{the size of the computational grid.}

\item{continuous}{logical; to choose which prediction to do perform, discrete or continuous, the default is continuous.}

\item{control.mcmc}{output from \code{\link{controlmcmcSDA}}, if not provided, it uses the values used for the parameter estimation.}

\item{pred.loc}{optional, the dataframe of the predictive grid.}

\item{divisor}{optional, the value to use to convert the dimension of the polygon, default is 1 which implies no conversion.}

\item{plot.correlogram}{logical; if plot.correlogram = TRUE the autocorrelation plot of the conditional simulations is displayed.}

\item{messages}{logical; if messages=TRUE then status messages are printed on the screen (or output device) while the function is running. Default is messages=TRUE.}

\item{parallel}{to parallelize some part of the function.}

\item{n.window}{the number of partitions to use for prediction. This is basically stratifying the predictive grid into fewer pieces}
}
\value{
pred.draw: the samples of the prediction

pred: the prediction of the relative risk

predSD: the standard error of the prediction

Pred.loc: The coordinates of the predictive locations
}
\description{
This function performs spatial continuous and discrete prediction, fixing the model parameters at the Monte Carlo maximum likelihood estimates of a SDALGCP model.
}
\details{
The function perform prediction of the spatially discrete incidence and covariate adjusted relative risk, and spatially continuous relative risk. The discrete inference uses the Metropolis-Adjusted Langevin Hasting sampling from \code{\link{Laplace.sampling}}. And the continuous inference is typically change of support inference.
}
\examples{
# check vignette for examples
}
\references{
Banerjee, S., Carlin, B. P., & Gelfand, A. E. (2014). Hierarchical modeling and analysis for spatial data. CRC press.
}
\seealso{
\link{plot.Pred.SDALGCPST}, \link{SDAContinuousPred}, \link{SDADiscretePred}, \link{plot_continuous}, \link{plot_discrete}
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
