% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{draw_trajectory_plot}
\alias{draw_trajectory_plot}
\title{Visualise SCORPIUS}
\usage{
draw_trajectory_plot(space, progression_group=NULL, path=NULL, contour=FALSE)
}
\arguments{
\item{space}{A numeric matrix or data frame containing the coordinates of samples.}

\item{progression_group}{\code{NULL} or a vector (or factor) containing the groupings of the samples (default \code{NULL}).}

\item{path}{A numeric matrix or data frame containing the coordinates of the inferred path.}

\item{contour}{\code{TRUE} if contours are to be drawn around the samples.}
}
\value{
A ggplot2 plot.
}
\description{
\code{draw_trajectory_plot} is used to plot samples after performing dimensionality reduction.
Additional arguments can be provided to colour the samples, plot the trajectory inferred by SCORPIUS,
and draw a contour around the samples.
}
\examples{
## Generate a synthetic dataset
dataset <- generate_dataset(type="p", num_genes=500, num_samples=300, num_groups=4)
dist <- correlation_distance(dataset$expression)
space <- reduce_dimensionality(dist, ndim=2)
groups <- dataset$sample_info$group_name

## Simply plot the samples
draw_trajectory_plot(space)

## Colour each sample according to its group
draw_trajectory_plot(space, progression_group=groups)

## Add contours to the plot
draw_trajectory_plot(space, progression_group=groups, contour=TRUE)

## Plot contours without colours
draw_trajectory_plot(space, contour=TRUE)

## Infer a trajectory and plot it
traj <- infer_trajectory(space)
draw_trajectory_plot(space, progression_group=groups, path=traj$path)
draw_trajectory_plot(space, progression_group=groups, path=traj$path, contour=TRUE)
}
