% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynwrap_integration.R
\name{ti_scorpius}
\alias{ti_scorpius}
\title{Infer a trajectory using SCORPIUS}
\usage{
ti_scorpius(
  distance_method = "spearman",
  ndim = 3L,
  k = 4L,
  thresh = 0.001,
  maxit = 10L,
  stretch = 0,
  smoother = "smooth_spline"
)
}
\arguments{
\item{distance_method}{A character string indicating which correlationcoefficient (or covariance) is to be computed. One of "pearson", "spearman" (default), or "cosine". Domain: {spearman, pearson, cosine}. Default: spearman. Format: character.}

\item{ndim}{The number of dimensions in the new space. Domain: U(2, 20). Default: 3. Format: integer.}

\item{k}{The number of clusters to cluster the data into to construct the initial trajectory. Domain: U(1, 20). Default: 4. Format: integer.}

\item{thresh}{\code{principal_curve} parameter; convergence threshhold on shortest distances to the curve. Domain: e^U(-11.51, 11.51). Default: 0.001. Format: numeric.}

\item{maxit}{\code{principal_curve} parameter; maximum number of iterations. Domain: U(0, 50). Default: 10. Format: integer.}

\item{stretch}{\code{principal_curve} parameter; a factor by which the curve can be extrapolated when points are projected. Domain: U(0, 5). Default: 0. Format: numeric.}

\item{smoother}{\code{principal_curve} parameter; choice of smoother. Domain: {smooth_spline, lowess, periodic_lowess}. Default: smooth_spline. Format: character.}
}
\description{
Pass this object to \code{\link[dynwrap:infer_trajectories]{dynwrap::infer_trajectory()}}.
}
