% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertParameters.R
\name{convertParameters}
\alias{convertParameters}
\title{Parameter estimates from a nonlinear lest squares (NLS) fit.}
\usage{
convertParameters(curve)
}
\arguments{
\item{curve}{A fitted model object from nls function. The fitted model should have the following
parameter estimates - amplitude, intercept, frequency, phase.}
}
\value{
A list containing the following components:

\item{amplitude}{estimated amplitude}
\item{intercept}{estimated intercept}
\item{x0}{delay of the data}
\item{X}{period of the data}
\item{birth}{birth seasonality estimate}
}
\description{
This function converts the estimated parameters from the non-linear least squares (NLS) model fit to the appropriate parameter space corresponding to the cosine model proposed by Balasse et al (2012).
}
\examples{
armenia_split = split(armenia,f = armenia$ID)
curve = sineFit(armenia_split[[1]],method = "OLS")
convertParameters(curve)
}
