% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\title{Gets a named table from a given schema}
\usage{
get_table(conn, db_table_id = NULL, slice_ts = NA, include_slice_info = FALSE)
}
\arguments{
\item{conn}{An object that inherits from DBIConnection (as generated by get_connection())'}

\item{db_table_id}{A \code{\link[DBI:Id]{DBI::Id()}} object or a character string readable by \link{id}.
If missing, a list of available tables is printed.}

\item{slice_ts}{If set different from NA (default), the returned data looks as on the given date.
If set as NULL, all data is returned}

\item{include_slice_info}{Default FALSE.
If set TRUE, the history columns "checksum", "from_ts", "until_ts" are returned also}
}
\value{
A "lazy" dataframe (tbl_lazy) generated using dbplyr
}
\description{
Gets a named table from a given schema
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

dplyr::copy_to(conn, mtcars, name = "mtcars")

get_table(conn)
if (table_exists(conn, "mtcars")) {
  get_table(conn, "mtcars")
}

close_connection(conn)
}
