% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequential_imputation.R
\name{apply_locf_nocb}
\alias{apply_locf_nocb}
\title{Impute Missing Values Using LOCF and NOCB}
\usage{
apply_locf_nocb(X, subject_id)
}
\arguments{
\item{X}{A matrix where rows represent observations and columns represent variables.}

\item{subject_id}{A vector of subject IDs corresponding to the rows of \code{X}.}
}
\value{
A matrix with missing values imputed using LOCF and NOCB.
}
\description{
Imputes missing values in a matrix by applying Last Observation Carried Forward (LOCF) followed by
Next Observation Carried Backward (NOCB) for each subject.
}
\examples{
X <- matrix(c(NA, 2, NA, 4, 5, NA, 7, 8, NA, NA), nrow = 5, byrow = TRUE)
subject_id <- c(1, 1, 1, 2, 2)
apply_locf_nocb(X, subject_id)

}
